/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.axis;

import filenet.vw.base.logging.Logger;
import filenet.ws.listener.axis.SOAPMessageUtils;
import filenet.ws.listener.axis.rm.WSRMUtils;
import filenet.ws.utils.WSLogger;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PostHandler
extends BasicHandler {
    protected static Logger logger = Logger.getLogger("filenet.ws.listener.axis");
    protected static final String m_className = "PostHandler";

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 17:35:32  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.5  $";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext msgContext) throws AxisFault {
        String m_method = "invoke";
        try {
            Message msg;
            block16: {
                logger.entering(m_className, "invoke");
                Boolean required = (Boolean)msgContext.getProperty("MC.P8BPM.POST.REQUIRED");
                if (required == null || !required.booleanValue()) {
                    if (logger.isFinest()) {
                        logger.finest(m_className, "invoke", "No post handling required");
                    }
                    return;
                }
                if (WSRMUtils.isRMSequenceMessage(msgContext)) {
                    if (logger.isFinest()) {
                        logger.finest(m_className, "invoke", "RM - No post handling required");
                    }
                    return;
                }
                if (logger.isFinest()) {
                    logger.finest(m_className, "invoke", "Set response message");
                }
                msg = msgContext.getRequestMessage();
                try {
                    SOAPHeader hdr = msg.getSOAPHeader();
                    if (hdr != null) {
                        NodeList nl = hdr.getChildNodes();
                        int nItems = nl == null ? 0 : nl.getLength();
                        Node replyHeaderNode = null;
                        for (int nn = 0; nn < nItems; ++nn) {
                            Node aNode = nl.item(nn);
                            if (!aNode.getNodeName().contains("ReplyHeader")) continue;
                            replyHeaderNode = aNode;
                            if (!logger.isFinest()) break;
                            logger.finest(m_className, "invoke", "Found ReplyHeader -- removing it..");
                            break;
                        }
                        if (replyHeaderNode != null) {
                            hdr.removeChild(replyHeaderNode);
                        }
                    }
                }
                catch (SOAPException e) {
                    if (!logger.isFinest()) break block16;
                    logger.throwing(m_className, "invoke", e);
                }
            }
            msg.setMessageType("response");
            msgContext.setResponseMessage(msg);
            WSLogger m_wsLogger = (WSLogger)msgContext.getProperty("MC.P8BPM.WSLOGGER");
            if (m_wsLogger != null) {
                StringBuffer buf = SOAPMessageUtils.exploreMessage((SOAPMessage)msg);
                m_wsLogger.append("Response SOAP Message=").append(buf).eoln();
                m_wsLogger.println("PostHandler OK.");
            }
        }
        finally {
            logger.exiting(m_className, "invoke");
        }
    }
}

